//
//  MCTrackedProcess.h
//  MCServerSupport
//
//  Created by Brent Gulanowski on 15/08/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//


#import <CoreData/NSManagedObject.h>


extern NSString *kMCETEntityProcess;


@interface MCTrackedProcess : NSManagedObject {

	NSMutableArray *stateInfoStack;
	NSMutableArray *levelIndexStack;
	
	unsigned logLevel;
	BOOL useNumberedPrefix;
	
	BOOL stateChanged;
}

+ (void)test;
// index should probably be "count"; it's only used if you set enumerated prefixes
+ (NSString *)prefixForLevel:(unsigned)level index:(unsigned)index;

// push the empty string to increase level without increasing index count; returns new height of state stack
- (unsigned)pushStateInfo:(NSString *)info;
// pop the state stack to one below the provided height; provide zero to pop one level
- (void)popStateInfo:(unsigned)height;
- (void)popStateInfo;
- (void)replaceStateInfo:(NSString *)info; // increases index by 1
- (void)setStateInfo:(NSString *)info;
- (BOOL)useNumberedPrefix;
- (void)setUseNumberedPrefix:(BOOL)flag;

- (void)resetState;
- (NSString *)stateDescription;

- (unsigned)logLevel;
- (void)setLogLevel:(unsigned)level;

- (void)logMessage:(NSString *)msg;

@end
